/*
 * Decompiled with CFR 0.152.
 */
package com.technicalitiesmc.scm.placement;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.technicalitiesmc.lib.circuit.component.CircuitComponent;
import com.technicalitiesmc.lib.circuit.component.ComponentContext;
import com.technicalitiesmc.lib.circuit.component.ComponentSlot;
import com.technicalitiesmc.lib.circuit.component.ComponentState;
import com.technicalitiesmc.lib.circuit.component.ComponentType;
import com.technicalitiesmc.lib.circuit.placement.ComponentPlacement;
import com.technicalitiesmc.lib.circuit.placement.PlacementContext;
import com.technicalitiesmc.lib.math.VecDirection;
import com.technicalitiesmc.lib.math.VecDirectionFlags;
import com.technicalitiesmc.lib.util.AbstractFlags8;
import com.technicalitiesmc.scm.block.CircuitBlock;
import com.technicalitiesmc.scm.component.misc.PlatformComponent;
import com.technicalitiesmc.scm.init.SCMComponents;
import com.technicalitiesmc.scm.init.SCMItems;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.registries.RegistryObject;

public class WirePlacement
implements ComponentPlacement {
    private final RegistryObject<ComponentType> component;
    private final Factory factory;
    private final StateFactory stateFactory;

    public WirePlacement(RegistryObject<ComponentType> component, Factory factory, StateFactory stateFactory) {
        this.component = component;
        this.factory = factory;
        this.stateFactory = stateFactory;
    }

    public Instance begin() {
        return new Instance();
    }

    public Instance deserialize(FriendlyByteBuf buf) {
        Instance instance = new Instance();
        int count = buf.readInt();
        for (int i = 0; i < count; ++i) {
            BlockPos pos = buf.m_130135_();
            VecDirectionFlags sides = VecDirectionFlags.deserialize((byte)buf.readByte());
            instance.connectionMap.put((Vec3i)pos, sides);
        }
        int supportCount = buf.readInt();
        for (int i = 0; i < supportCount; ++i) {
            instance.supports.add((Vec3i)buf.m_130135_());
        }
        instance.disconnectOthers = buf.readBoolean();
        return instance;
    }

    @FunctionalInterface
    public static interface Factory {
        public CircuitComponent create(ComponentContext var1, VecDirectionFlags var2, boolean var3, Player var4);
    }

    @FunctionalInterface
    public static interface StateFactory {
        public ComponentState create(VecDirectionFlags var1, Player var2);
    }

    private class Instance
    implements ComponentPlacement.Instance {
        private final Set<Vec3i> uniquePositions = new HashSet<Vec3i>();
        private final Set<Vec3i> supports = new HashSet<Vec3i>();
        private final List<Vec3i> positions = new ArrayList<Vec3i>();
        private final List<VecDirectionFlags> connections = new ArrayList<VecDirectionFlags>();
        private final Map<Vec3i, VecDirectionFlags> connectionMap = new HashMap<Vec3i, VecDirectionFlags>();
        private boolean disconnectOthers;

        private Instance() {
        }

        @Nullable
        public VoxelShape createOverrideShape(PlacementContext.Client context, Vec3i clickedPos, VecDirection clickedFace, HitResult hit) {
            Vec3i pos = clickedPos.m_141952_(clickedFace.getOffset());
            Vec3i supportPos = pos.m_7495_();
            return CircuitBlock.makeGrid(-1, 8, -1, 8, supportPos.m_123342_());
        }

        public boolean tick(PlacementContext.Client context, Vec3i clickedPos, VecDirection clickedFace) {
            this.disconnectOthers = context.isModifierPressed();
            Vec3i pos = clickedPos.m_141952_(clickedFace.getOffset());
            if (!context.canPlace(pos, (ComponentType)WirePlacement.this.component.get())) {
                return !this.positions.isEmpty();
            }
            int idx = this.positions.lastIndexOf(pos);
            if (idx != -1) {
                if (idx == this.positions.size() - 1) {
                    this.connections.set(idx, this.computeConnections(context, pos));
                    return true;
                }
                if (idx > this.positions.size() - 4) {
                    int start = Math.max(0, idx + 1);
                    List<Vec3i> backtracked = this.positions.subList(start, this.positions.size());
                    for (Vec3i bPos : backtracked) {
                        this.supports.remove(bPos.m_7495_());
                    }
                    backtracked.clear();
                    this.connections.subList(start, this.connections.size()).clear();
                    this.uniquePositions.clear();
                    this.uniquePositions.addAll(this.positions);
                    return true;
                }
            }
            if (!this.positions.isEmpty() && this.positions.get(this.positions.size() - 1).m_123333_(pos) > 1) {
                return true;
            }
            if (!context.getPlayer().m_7500_() && this.uniquePositions.size() >= context.getStack().m_41613_()) {
                return true;
            }
            if (!context.isTopSolid(pos.m_7495_())) {
                if (context.get(pos.m_7495_(), ComponentSlot.SUPPORT) != null) {
                    return true;
                }
                if (!context.getPlayer().m_7500_() && context.getPlayer().m_150109_().m_18947_((Item)SCMItems.PLATFORM.get()) < this.supports.size() + 1) {
                    return true;
                }
                this.supports.add(pos.m_7495_());
            }
            this.uniquePositions.add(pos);
            this.positions.add(pos);
            this.connections.add(this.computeConnections(context, pos));
            return true;
        }

        private VecDirectionFlags computeConnections(PlacementContext.Client context, Vec3i pos) {
            Vec3i prevPos;
            Vec3i vec3i = prevPos = this.positions.size() >= 2 ? this.positions.get(this.positions.size() - 2) : null;
            if (prevPos == null) {
                return VecDirectionFlags.none();
            }
            if (prevPos.m_123333_(pos) != 1) {
                return VecDirectionFlags.none();
            }
            VecDirection sideFrom = VecDirection.getNearest((Vec3i)prevPos.m_141950_(pos));
            if (sideFrom.getAxis() == Direction.Axis.Y) {
                return VecDirectionFlags.none();
            }
            return VecDirectionFlags.of((VecDirection[])new VecDirection[]{sideFrom});
        }

        public void stopPlacing(PlacementContext.Client context) {
            this.disconnectOthers = context.isModifierPressed();
        }

        private void coalesce() {
            this.connectionMap.clear();
            for (int i = 0; i < this.positions.size(); ++i) {
                Vec3i pos2 = this.positions.get(i);
                VecDirectionFlags sides2 = this.connections.get(i);
                VecDirectionFlags current = this.connectionMap.getOrDefault(pos2, VecDirectionFlags.none());
                this.connectionMap.put(pos2, (VecDirectionFlags)current.and((AbstractFlags8)sides2));
            }
            this.connectionMap.forEach((pos, sides) -> {
                for (VecDirection side : sides) {
                    Vec3i neighborPos = pos.m_141952_(side.getOffset());
                    this.connectionMap.computeIfPresent(neighborPos, ($, s) -> (VecDirectionFlags)s.and((Enum)side.getOpposite()));
                }
            });
        }

        public boolean isValid(PlacementContext.Client context) {
            this.coalesce();
            return !this.connectionMap.isEmpty();
        }

        public void serialize(FriendlyByteBuf buf) {
            buf.writeInt(this.connectionMap.size());
            this.connectionMap.forEach((pos, sides) -> {
                buf.m_130064_(new BlockPos(pos));
                buf.writeByte((int)sides.serialize());
            });
            buf.writeInt(this.supports.size());
            this.supports.forEach(pos -> buf.m_130064_(new BlockPos(pos)));
            buf.writeBoolean(this.disconnectOthers);
        }

        public void place(PlacementContext.Server context) {
            if (context.tryPutAll(ctx -> {
                for (Map.Entry<Vec3i, VecDirectionFlags> entry : this.connectionMap.entrySet()) {
                    Vec3i pos = entry.getKey();
                    Vec3i below = pos.m_7495_();
                    if (this.supports.contains(below) && !ctx.at(below, (ComponentType)SCMComponents.PLATFORM.get(), PlatformComponent::new)) {
                        return false;
                    }
                    if (ctx.at(pos, (ComponentType)WirePlacement.this.component.get(), c -> WirePlacement.this.factory.create(c, (VecDirectionFlags)entry.getValue(), this.disconnectOthers, context.getPlayer()))) continue;
                    return false;
                }
                return true;
            })) {
                context.consumeItems(this.connectionMap.size());
                if (!this.supports.isEmpty()) {
                    context.consumeItems((Item)SCMItems.PLATFORM.get(), this.supports.size());
                }
                context.playSound();
            }
        }

        public Multimap<Vec3i, ComponentState> getPreviewStates(Player player) {
            this.coalesce();
            ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
            this.connectionMap.forEach((pos, connections) -> builder.put(pos, (Object)WirePlacement.this.stateFactory.create((VecDirectionFlags)connections, player)));
            for (Vec3i pos2 : this.supports) {
                builder.put((Object)pos2, (Object)((ComponentType)SCMComponents.PLATFORM.get()).getDefaultState());
            }
            return builder.build();
        }
    }
}

